library(memisc)

ESS.1.sav <- spss.system.file("Data/ESS/ESS1e06_6.sav")
Write(description(ESS.1.sav),file="ESS-01-sav-desc.txt")
Write(codebook(ESS.1.sav),file="ESS-01-sav-cdbk.txt")

ESS.1 <- subset(ESS.1.sav,
                select=c(
                    essround,
                    idno,
                    cntry,
                    voted         = vote,
                    vote.austria  = prtvtat,
                    vote.belgium  = prtvtbe,
                    vote.switzerland    = prtvtch,
                    vote.czechia  = prtvtcz,
                    vote.germany  = prtvde2,
                    vote.denmark  = prtvtdk,
                    vote.spain    = prtvtes,
                    vote.finland  = prtvtfi,
                    vote.france   = prtvtfr,
                    vote.uk       = prtvtgb,
                    vote.greece   = prtvtgr,
                    vote.hungary  = prtvthu,
                    vote.ireland  = prtvtie,
                    vote.israel   = prtvtil,
                    vote.italy    = prtvtit,
                    vote.luxembourg = prtvtlu,
                    vote.netherla = prtvtnl,
                    vote.norway   = prtvtno,
                    vote.poland   = prtvtpl,
                    vote.portugal = prtvtpt,
                    vote.sweden   = prtvtse,
                    vote.slovenia = prtvtsi,
                    important_creative   = ipcrtiv,
                    important_rich       = imprich,
                    important_equality   = ipeqopt,
                    important_admired    = ipshabt,
                    important_safe       = impsafe,
                    important_trynew     = impdiff,
                    important_obedient   = ipfrule,
                    important_understand = ipudrst,
                    important_modest     = ipmodst,
                    important_goodtime   = ipgdtim,
                    important_freedom    = impfree,
                    important_helpothers = iphlppl,
                    important_success    = ipsuces,
                    important_stronggov  = ipstrgv,
                    important_exciting   = ipadvnt,
                    important_behavprop  = ipbhprp,
                    important_respect    = iprspot,
                    important_friends    = iplylfr,
                    important_environmt  = impenv,
                    important_tradition  = imptrad,
                    important_fun        = impfun,
                    reldenom.any  = rlgblg,
                    reldenom      = rlgdnm,   
                    frm.reldenom.any     = rlgblge,
                    frm.reldenom         = rlgdnme,
                    religious     = rlgdgr,
                    relig.attend  = rlgatnd,
                    pray          = pray,
                    gender        = gndr,
                    age           = agea,
                    ybirth        = yrbrn,
                    eactive       = mnactic,
                    emplrel,
                    emplno,
                    isco88        = iscoco,
                    supervises    = jbspv,
                    nsupervised   = njbspv,
                    industry      = nacer1,
                    eactivep      = mnactp,
                    emplrelp      = emprelp,
                    emplnop,
                    supervisesp   = jbspvp,
                    nsupervisedp  = njbspvp,
                    isco88prtnr   = iscocop,
                    regionbe,
                    regionde,
                    regiongb,
                    regiones,
                    ger.eastwest  = intewde,
                    w.design      = dweight,
                    w.poststrat   = pspwght,
                    year          = inwyr
                ))
Write(codebook(ESS.1),file="ESS-01-cdbk.txt")


ESS.2.sav <- spss.system.file("Data/ESS/ESS2e03_6.sav")
Write(description(ESS.2.sav),file="ESS-02-sav-desc.txt")
Write(codebook(ESS.2.sav),file="ESS-02-sav-cdbk.txt")

ESS.2 <- subset(ESS.2.sav,
                select=c(
                    essround,
                    idno,
                    cntry,
                    voted         = vote,
                    vote.austria  = prtvtat,
                    vote.belgium  = prtvtabe,
                    vote.switzerland    = prtvtch,
                    vote.czechia  = prtvtcz,
                    vote.germany  = prtvade2,
                    vote.denmark  = prtvtdk,
                    vote.estonia  = prtvtee,
                    vote.spain    = prtvtaes,
                    vote.finland  = prtvtfi,
                    vote.france   = prtvtfr,
                    vote.uk       = prtvtgb,
                    vote.greece   = prtvtagr,
                    vote.ireland  = prtvtie,
                    vote.iceland  = prtvtis,
                    vote.italy    = prtvtait,
                    vote.luxembourg = prtvtlu,
                    vote.netherla = prtvtanl,
                    vote.norway   = prtvtno,
                    vote.poland   = prtvtpl,
                    vote.portugal = prtvtpt,
                    vote.sweden   = prtvtse,
                    vote.slovenia = prtvtasi,
                    vote.slovakia = prtvtsk,
                    vote.turkey   = prtvttr,
                    vote.ukraine  = prtvtua,
                    important_creative   = ipcrtiv,
                    important_rich       = imprich,
                    important_equality   = ipeqopt,
                    important_admired    = ipshabt,
                    important_safe       = impsafe,
                    important_trynew     = impdiff,
                    important_obedient   = ipfrule,
                    important_understand = ipudrst,
                    important_modest     = ipmodst,
                    important_goodtime   = ipgdtim,
                    important_freedom    = impfree,
                    important_helpothers = iphlppl,
                    important_success    = ipsuces,
                    important_stronggov  = ipstrgv,
                    important_exciting   = ipadvnt,
                    important_behavprop  = ipbhprp,
                    important_respect    = iprspot,
                    important_friends    = iplylfr,
                    important_environmt  = impenv,
                    important_tradition  = imptrad,
                    important_fun        = impfun,
                    reldenom.any  = rlgblg,
                    reldenom      = rlgdnm,   
                    frm.reldenom.any     = rlgblge,
                    frm.reldenom         = rlgdnme,
                    religious     = rlgdgr,
                    relig.attend  = rlgatnd,
                    pray          = pray,
                    gender        = gndr,
                    age           = agea,
                    ybirth        = yrbrn,
                    eactive       = mnactic,
                    emplrel,
                    emplno,
                    isco88        = iscoco,
                    supervises    = jbspv,
                    nsupervised   = njbspv,
                    industry      = nacer11,
                    eactivep      = mnactp,
                    emplrelp      = emprelp,
                    emplnop,
                    supervisesp   = jbspvp,
                    nsupervisedp  = njbspvp,
                    isco88prtnr   = iscocop,
                    regionbe,
                    regionde,
                    regiongb,
                    regiones,
                    ger.eastwest  = intewde,
                    w.design      = dweight,
                    w.poststrat   = pspwght,
                    year          = inwyr
                ))
Write(codebook(ESS.2),file="ESS-02-cdbk.txt")



ESS.3.sav <- spss.system.file("Data/ESS/ESS3e03_7.sav")
Write(description(ESS.3.sav),file="ESS-03-sav-desc.txt")
Write(codebook(ESS.3.sav),file="ESS-03-sav-cdbk.txt")

ESS.3 <- subset(ESS.3.sav,
                select=c(
                    essround,
                    idno,
                    cntry,
                    voted         = vote,
                    vote.austria  = prtvtaat,
                    vote.belgium  = prtvtabe,
                    vote.bulgaria = prtvtbg,
                    vote.switzerland    = prtvtach,
                    vote.cyprus   = prtvtcy,
                    vote.germany  = prtvbde2,
                    vote.denmark  = prtvtadk,
                    vote.spain    = prtvtaes,
                    vote.finland  = prtvtfi,
                    vote.france   = prtvtafr,
                    vote.uk       = prtvtagb,
                    vote.hungary  = prtvtahu,
                    vote.ireland  = prtvtie,
                    vote.estonia  = prtvtaee,
                    vote.latvia   = prtvtlv,
                    vote.netherla = prtvtbnl,
                    vote.norway   = prtvtno,
                    vote.poland   = prtvtapl,
                    vote.portugal = prtvtapt,
                    vote.romania  = prtvtro,
                    vote.russia   = prtvtru,
                    vote.sweden   = prtvtse,
                    vote.slovenia = prtvtbsi,
                    vote.slovakia = prtvtask,
                    vote.ukraine  = prtvtaua,
                    important_creative   = ipcrtiv,
                    important_rich       = imprich,
                    important_equality   = ipeqopt,
                    important_admired    = ipshabt,
                    important_safe       = impsafe,
                    important_trynew     = impdiff,
                    important_obedient   = ipfrule,
                    important_understand = ipudrst,
                    important_modest     = ipmodst,
                    important_goodtime   = ipgdtim,
                    important_freedom    = impfree,
                    important_helpothers = iphlppl,
                    important_success    = ipsuces,
                    important_stronggov  = ipstrgv,
                    important_exciting   = ipadvnt,
                    important_behavprop  = ipbhprp,
                    important_respect    = iprspot,
                    important_friends    = iplylfr,
                    important_environmt  = impenv,
                    important_tradition  = imptrad,
                    important_fun        = impfun,
                    reldenom.any  = rlgblg,
                    reldenom      = rlgdnm,   
                    frm.reldenom.any     = rlgblge,
                    frm.reldenom         = rlgdnme,
                    religious     = rlgdgr,
                    relig.attend  = rlgatnd,
                    pray          = pray,
                    gender        = gndr,
                    age           = agea,
                    ybirth        = yrbrn,
                    eactive       = mnactic,
                    emplrel,
                    emplno,
                    isco88        = iscoco,
                    supervises    = jbspv,
                    nsupervised   = njbspv,
                    industry      = nacer11,
                    eactivep      = mnactp,
                    emplrelp      = emprelp,
                    emplnop,
                    supervisesp   = jbspvp,
                    nsupervisedp  = njbspvp,
                    isco88prtnr   = iscocop,
                    regionbe,
                    regionde,
                    regiongb,
                    regioaes,
                    ger.eastwest  = intewde,
                    w.design      = dweight,
                    w.poststrat   = pspwght,
                    year          = inwyys
                ))
Write(codebook(ESS.3),file="ESS-03-cdbk.txt")



ESS.4.sav <- spss.system.file("Data/ESS/ESS4e04_5.sav")
Write(description(ESS.4.sav),file="ESS-04-sav-desc.txt")
Write(codebook(ESS.4.sav),file="ESS-04-sav-cdbk.txt")

ESS.4 <- subset(ESS.4.sav,
                select=c(
                    essround,
                    idno,
                    cntry,
                    voted         = vote,
                    vote.austria  = prtvtaat,
                    vote.belgium  = prtvtbbe,
                    vote.bulgaria = prtvtabg,
                    vote.switzerland    = prtvtbch,
                    vote.cyprus   = prtvtcy,
                    vote.czechia  = prtvtacz,
                    vote.germany  = prtvbde2,
                    vote.denmark  = prtvtbdk,
                    vote.estonia  = prtvtbee,
                    vote.spain    = prtvtbes,
                    vote.finland  = prtvtafi,
                    vote.france   = prtvtbfr,
                    vote.uk       = prtvtgb,
                    vote.greece   = prtvtbgr,
                    vote.croatia  = prtvthr,
                    vote.hungary  = prtvtbhu,
                    vote.ireland  = prtvtie,
                    vote.israel   = prtvtail,
                    vote.lithuania1 = prtvlt1,
                    vote.lithuania2 = prtvlt2,
                    vote.lithuania3 = prtvlt3,
                    vote.latvia   = prtvtlv,
                    vote.netherla = prtvtcnl,
                    vote.norway   = prtvtno,
                    vote.poland   = prtvtbpl,
                    vote.portugal = prtvtapt,
                    vote.romania  = prtvtaro,
                    vote.russia   = prtvtaru,
                    vote.sweden   = prtvtse,
                    vote.slovenia = prtvtcsi,
                    vote.slovakia = prtvtask,
                    vote.turkey   = prtvtatr,
                    vote.ukraine  = prtvtbua,
                    important_creative   = ipcrtiv,
                    important_rich       = imprich,
                    important_equality   = ipeqopt,
                    important_admired    = ipshabt,
                    important_safe       = impsafe,
                    important_trynew     = impdiff,
                    important_obedient   = ipfrule,
                    important_understand = ipudrst,
                    important_modest     = ipmodst,
                    important_goodtime   = ipgdtim,
                    important_freedom    = impfree,
                    important_helpothers = iphlppl,
                    important_success    = ipsuces,
                    important_stronggov  = ipstrgv,
                    important_exciting   = ipadvnt,
                    important_behavprop  = ipbhprp,
                    important_respect    = iprspot,
                    important_friends    = iplylfr,
                    important_environmt  = impenv,
                    important_tradition  = imptrad,
                    important_fun        = impfun,
                    reldenom.any  = rlgblg,
                    reldenom      = rlgdnm,   
                    reldenom.austria     = rlgdnat,
                    reldenom.switzerland = rlgdnch,
                    reldenom.cyprus      = rlgdncy,
                    reldenom.finland     = rlgdnfi,
                    reldenom.uk          = rlgdngb,
                    reldenom.hungary     = rlgdnhu,
                    reldenom.ireland     = rlgdnie,
                    reldenom.israel      = rlgdnil,
                    reldenom.lithuania   = rlgdnlt,
                    reldenom.latvia      = rlgdnlv,
                    reldenom.netherla    = rlgdnnl,
                    reldenom.norway      = rlgdnno,
                    reldenom.poland      = rlgdnpl,
                    reldenom.portugal    = rlgdnpt,
                    reldenom.romania     = rlgdnro,
                    reldenom.russia      = rlgdnru,
                    reldenom.sweden      = rlgdnse,
                    reldenom.slovakia    = rlgdnsk,
                    reldenom.ukraine     = rlgdnua,
                    frm.reldenom.any     = rlgblge,
                    frm.reldenom         = rlgdnme,
                    frm.reldenom.austria     = rlgdeat,
                    frm.reldenom.switzerland = rlgdech,
                    frm.reldenom.cyprus      = rlgdecy,
                    frm.reldenom.finland     = rlgdefi,
                    frm.reldenom.uk          = rlgdegb,
                    frm.reldenom.hungary     = rlgdehu,
                    frm.reldenom.ireland     = rlgdeie,
                    frm.reldenom.israel      = rlgdeil,
                    frm.reldenom.lithuania   = rlgdelt,
                    frm.reldenom.latvia      = rlgdelv,
                    frm.reldenom.netherla    = rlgdenl,
                    frm.reldenom.norway      = rlgdeno,
                    frm.reldenom.poland      = rlgdepl,
                    frm.reldenom.portugal    = rlgdept,
                    frm.reldenom.romania     = rlgdero,
                    frm.reldenom.russia      = rlgderu,
                    frm.reldenom.sweden      = rlgdese,
                    frm.reldenom.slovakia    = rlgdesk,
                    frm.reldenom.ukraine     = rlgdeua,
                    religious     = rlgdgr,
                    relig.attend  = rlgatnd,
                    pray          = pray,
                    gender        = gndr,
                    age           = agea,
                    ybirth        = yrbrn,
                    eactive       = mnactic,
                    emplrel,
                    emplno,
                    isco88        = iscoco,
                    supervises    = jbspv,
                    nsupervised   = njbspv,
                    industry      = nacer11,
                    eactivep      = mnactp,
                    emplrelp      = emprelp,
                    emplnop,
                    supervisesp   = jbspvp,
                    nsupervisedp  = njbspvp,
                    isco88prtnr   = iscocop,
                    regionbe,
                    regionde,
                    regiongb,
                    regioaes,
                    ger.eastwest  = intewde,
                    w.design      = dweight,
                    w.poststrat   = pspwght,
                    year          = inwyys
                ))
Write(codebook(ESS.4),file="ESS-04-cdbk.txt")



ESS.5.sav <- spss.system.file("Data/ESS/ESS5e03_4.sav")
Write(description(ESS.5.sav),file="ESS-05-sav-desc.txt")
Write(codebook(ESS.5.sav),file="ESS-05-sav-cdbk.txt")

ESS.5 <- subset(ESS.5.sav,
                select=c(
                    essround,
                    idno,
                    cntry,
                    voted         = vote,
                    vote.belgium  = prtvtcbe,
                    vote.bulgaria = prtvtbbg,
                    vote.switzerland    = prtvtcch,
                    vote.croatia  = prtvthr,
                    vote.cyprus   = prtvtcy,
                    vote.czechia  = prtvtbcz,
                    vote.germany  = prtvcde2,
                    vote.denmark  = prtvtbdk,
                    vote.estonia  = prtvtcee,
                    vote.spain    = prtvtbes,
                    vote.finland  = prtvtbfi,
                    vote.france   = prtvtbfr,
                    vote.uk       = prtvtgb,
                    vote.greece   = prtvtcgr,
                    vote.hungary  = prtvtchu,
                    vote.ireland  = prtvtaie,
                    vote.israel   = prtvtbil,
                    vote.lithuania1 = prtvlt1,
                    vote.lithuania2 = prtvlt2,
                    vote.lithuania3 = prtvlt3,
                    vote.netherla = prtvtdnl,
                    vote.norway   = prtvtano,
                    vote.poland   = prtvtbpl,
                    vote.portugal = prtvtbpt,
                    vote.russia   = prtvtbru,
                    vote.sweden   = prtvtase,
                    vote.slovenia = prtvtcsi,
                    vote.slovakia = prtvtbsk,
                    vote.ukraine  = prtvtbua,
                    important_creative   = ipcrtiv,
                    important_rich       = imprich,
                    important_equality   = ipeqopt,
                    important_admired    = ipshabt,
                    important_safe       = impsafe,
                    important_trynew     = impdiff,
                    important_obedient   = ipfrule,
                    important_understand = ipudrst,
                    important_modest     = ipmodst,
                    important_goodtime   = ipgdtim,
                    important_freedom    = impfree,
                    important_helpothers = iphlppl,
                    important_success    = ipsuces,
                    important_stronggov  = ipstrgv,
                    important_exciting   = ipadvnt,
                    important_behavprop  = ipbhprp,
                    important_respect    = iprspot,
                    important_friends    = iplylfr,
                    important_environmt  = impenv,
                    important_tradition  = imptrad,
                    important_fun        = impfun,
                    reldenom.any  = rlgblg,
                    reldenom      = rlgdnm,   
                    reldenom.belgium     = rlgdnbe,
                    reldenom.switzerland = rlgdnach,
                    reldenom.cyprus      = rlgdncy,
                    reldenom.germany     = rlgdnde,
                    reldenom.denmark     = rlgdndk,
                    reldenom.finland     = rlgdnafi,
                    reldenom.uk          = rlgdngb,
                    reldenom.greece      = rlgdnagr,
                    reldenom.hungary     = rlgdnhu,
                    reldenom.ireland     = rlgdnie,
                    reldenom.israel      = rlgdnil,
                    reldenom.lithuania   = rlgdnlt,
                    reldenom.netherla    = rlgdnnl,
                    reldenom.norway      = rlgdnno,
                    reldenom.poland      = rlgdnapl,
                    reldenom.portugal    = rlgdnpt,
                    reldenom.russia      = rlgdnaru,
                    reldenom.sweden      = rlgdnase,
                    reldenom.slovenia    = rlgdnsi,
                    reldenom.slovakia    = rlgdnsk,
                    reldenom.ukraine     = rlgdnua,
                    frm.reldenom.any     = rlgblge,
                    frm.reldenom         = rlgdnme,
                    frm.reldenom.belgium     = rlgdebe,
                    frm.reldenom.switzerland = rlgdeach,
                    frm.reldenom.cyprus      = rlgdecy,
                    frm.reldenom.germany     = rlgdede,
                    frm.reldenom.denmark     = rlgdedk,
                    frm.reldenom.finland     = rlgdeafi,
                    frm.reldenom.uk          = rlgdegb,
                    frm.reldenom.greece      = rlgdeagr,
                    frm.reldenom.hungary     = rlgdehu,
                    frm.reldenom.ireland     = rlgdeie,
                    frm.reldenom.israel      = rlgdeil,
                    frm.reldenom.lithuania   = rlgdelt,
                    frm.reldenom.netherla    = rlgdenl,
                    frm.reldenom.norway      = rlgdeno,
                    frm.reldenom.poland      = rlgdeapl,
                    frm.reldenom.portugal    = rlgdept,
                    frm.reldenom.russia      = rlgdearu,
                    frm.reldenom.sweden      = rlgdease,
                    frm.reldenom.slovenia    = rlgdesi,
                    frm.reldenom.slovakia    = rlgdesk,
                    frm.reldenom.ukraine     = rlgdeua,
                    religious     = rlgdgr,
                    relig.attend  = rlgatnd,
                    pray          = pray,
                    gender        = gndr,
                    age           = agea,
                    ybirth        = yrbrn,
                    eactive       = mnactic,
                    emplrel,
                    emplno,
                    isco88        = iscoco,
                    supervises    = jbspv,
                    nsupervised   = njbspv,
                    industry      = nacer2,
                    eactivep      = mnactp,
                    emplrelp      = emprelp,
                    emplnop,
                    supervisesp   = jbspvp,
                    nsupervisedp  = njbspvp,
                    isco88prtnr   = iscocop,
                    region,
                    ger.eastwest  = intewde,
                    w.design      = dweight,
                    w.poststrat   = pspwght,
                    year          = inwyys
                ))
Write(codebook(ESS.5),file="ESS-05-cdbk.txt")



ESS.6.sav <- spss.system.file("Data/ESS/ESS6e02_4.sav")
Write(description(ESS.6.sav),file="ESS-06-sav-desc.txt")
Write(codebook(ESS.6.sav),file="ESS-06-sav-cdbk.txt")


ESS.6 <- subset(ESS.6.sav,
                select=c(
                    essround,
                    idno,
                    cntry,
                    voted         = vote,
                    vote.albania  = prtvtal,
                    vote.belgium  = prtvtcbe,
                    vote.bulgaria = prtvtcbg,
                    vote.switzerland    = prtvtdch,
                    vote.cyprus   = prtvtacy,
                    vote.czechia  = prtvtccz,
                    vote.germany  = prtvdde2,
                    vote.denmark  = prtvtcdk,
                    vote.estonia  = prtvtdee,
                    vote.spain    = prtvtces,
                    vote.finland  = prtvtcfi,
                    vote.france   = prtvtcfr,
                    vote.uk       = prtvtgb,
                    vote.hungary  = prtvtdhu,
                    vote.ireland  = prtvtaie,
                    vote.israel   = prtvtbil,
                    vote.iceland  = prtvtais,
                    vote.italy    = prtvtbit,
                    vote.lithuania1 = prtvalt1,
                    vote.lithuania2 = prtvalt2,
                    vote.lithuania3 = prtvalt3,
                    vote.netherla = prtvtenl,
                    vote.norway   = prtvtano,
                    vote.poland   = prtvtcpl,
                    vote.portugal = prtvtbpt,
                    vote.russia   = prtvtcru,
                    vote.sweden   = prtvtbse,
                    vote.slovenia = prtvtdsi,
                    vote.slovakia = prtvtcsk,
                    vote.ukraine  = prtvtcua,
                    vote.kosovo   = prtvtxk,
                    important_creative   = ipcrtiv,
                    important_rich       = imprich,
                    important_equality   = ipeqopt,
                    important_admired    = ipshabt,
                    important_safe       = impsafe,
                    important_trynew     = impdiff,
                    important_obedient   = ipfrule,
                    important_understand = ipudrst,
                    important_modest     = ipmodst,
                    important_goodtime   = ipgdtim,
                    important_freedom    = impfree,
                    important_helpothers = iphlppl,
                    important_success    = ipsuces,
                    important_stronggov  = ipstrgv,
                    important_exciting   = ipadvnt,
                    important_behavprop  = ipbhprp,
                    important_respect    = iprspot,
                    important_friends    = iplylfr,
                    important_environmt  = impenv,
                    important_tradition  = imptrad,
                    important_fun        = impfun,
                    reldenom.any  = rlgblg,
                    reldenom      = rlgdnm,   
                    reldenom.albaina     = rlgdnal,
                    reldenom.belgium     = rlgdnbe,
                    reldenom.switzerland = rlgdnach,
                    reldenom.cyprus      = rlgdncy,
                    reldenom.germany     = rlgdnade,
                    reldenom.finland     = rlgdnafi,
                    reldenom.uk          = rlgdngb,
                    reldenom.hungary     = rlgdnhu,
                    reldenom.ireland     = rlgdnie,
                    reldenom.israel      = rlgdnil,
                    reldenom.iceland     = rlgdnis,
                    reldenom.lithuania   = rlgdnlt,
                    reldenom.netherla    = rlgdnnl,
                    reldenom.norway      = rlgdnno,
                    reldenom.poland      = rlgdnapl,
                    reldenom.portugal    = rlgdnpt,
                    reldenom.russia      = rlgdnaru,
                    reldenom.sweden      = rlgdnase,
                    reldenom.slovenia    = rlgdnsi,
                    reldenom.slovakia    = rlgdnsk,
                    reldenom.ukraine     = rlgdnua,
                    frm.reldenom.any     = rlgblge,
                    frm.reldenom         = rlgdnme,
                    frm.reldenom.albania     = rlgdeal,
                    frm.reldenom.belgium     = rlgdebe,
                    frm.reldenom.switzerland = rlgdeach,
                    frm.reldenom.cyprus      = rlgdecy,
                    frm.reldenom.germany     = rlgdeade,
                    frm.reldenom.finland     = rlgdeafi,
                    frm.reldenom.uk          = rlgdegb,
                    frm.reldenom.hungary     = rlgdehu,
                    frm.reldenom.ireland     = rlgdeie,
                    frm.reldenom.israel      = rlgdeil,
                    frm.reldenom.iceland     = rlgdeis,
                    frm.reldenom.lithuania   = rlgdelt,
                    frm.reldenom.netherla    = rlgdenl,
                    frm.reldenom.norway      = rlgdeno,
                    frm.reldenom.poland      = rlgdeapl,
                    frm.reldenom.portugal    = rlgdept,
                    frm.reldenom.russia      = rlgdearu,
                    frm.reldenom.sweden      = rlgdease,
                    frm.reldenom.slovenia    = rlgdesi,
                    frm.reldenom.slovakia    = rlgdesk,
                    frm.reldenom.ukraine     = rlgdeua,
                    religious     = rlgdgr,
                    relig.attend  = rlgatnd,
                    pray          = pray,
                    gender        = gndr,
                    age           = agea,
                    ybirth        = yrbrn,
                    eactive       = mnactic,
                    emplrel,
                    emplno,
                    isco08,
                    supervises    = jbspv,
                    nsupervised   = njbspv,
                    industry      = nacer2,
                    isco08prtnr   = isco08p,
                    eactivep      = mnactp,
                    emplrelp      = emprelp,
                    #emplnop,                 # Missing in data set - Yuck!
                    #supervisesp   = jbspvp,
                    #nsupervisedp  = njbspvp,
                    region,
                    ger.eastwest  = intewde,
                    w.design      = dweight,
                    w.poststrat   = pspwght,
                    year          = inwyys
                ))
Write(codebook(ESS.6),file="ESS-06-cdbk.txt")


ESS.7.sav <- spss.system.file("Data/ESS/ESS7e02_2.sav")
Write(description(ESS.7.sav),file="ESS-07-sav-desc.txt")
Write(codebook(ESS.7.sav),file="ESS-07-sav-cdbk.txt")

ESS.7 <- subset(ESS.7.sav,
                select=c(
                    essround,
                    idno,
                    cntry,
                    voted         = vote,
                    vote.austria  = prtvtbat,
                    vote.belgium  = prtvtcbe,
                    vote.switzerland    = prtvtech,
                    vote.czechia  = prtvtdcz,
                    vote.germany  = prtvede2,
                    vote.denmark  = prtvtcdk,
                    vote.estonia  = prtvteee,
                    vote.spain    = prtvtces,
                    vote.finland  = prtvtcfi,
                    vote.france   = prtvtcfr,
                    vote.uk       = prtvtbgb,
                    vote.hungary  = prtvtehu,
                    vote.ireland  = prtvtaie,
                    vote.israel   = prtvtcil,
                    vote.lithuania1 = prtvalt1,
                    vote.lithuania2 = prtvalt2,
                    vote.lithuania3 = prtvalt3,
                    vote.netherla = prtvtfnl,
                    vote.norway   = prtvtbno,
                    vote.poland   = prtvtcpl,
                    vote.portugal = prtvtbpt,
                    vote.sweden   = prtvtbse,
                    vote.slovenia = prtvtesi,
                    important_creative   = ipcrtiv,
                    important_rich       = imprich,
                    important_equality   = ipeqopt,
                    important_admired    = ipshabt,
                    important_safe       = impsafe,
                    important_trynew     = impdiff,
                    important_obedient   = ipfrule,
                    important_understand = ipudrst,
                    important_modest     = ipmodst,
                    important_goodtime   = ipgdtim,
                    important_freedom    = impfree,
                    important_helpothers = iphlppl,
                    important_success    = ipsuces,
                    important_stronggov  = ipstrgv,
                    important_exciting   = ipadvnt,
                    important_behavprop  = ipbhprp,
                    important_respect    = iprspot,
                    important_friends    = iplylfr,
                    important_environmt  = impenv,
                    important_tradition  = imptrad,
                    important_fun        = impfun,
                    reldenom.any  = rlgblg,
                    reldenom      = rlgdnm,   
                    reldenom.austria     = rlgdnbat,
                    reldenom.belgium     = rlgdnbe,
                    reldenom.switzerland = rlgdnach,
                    reldenom.germany     = rlgdnade,
                    reldenom.finland     = rlgdnafi,
                    reldenom.uk          = rlgdngb,
                    reldenom.hungary     = rlgdnhu,
                    reldenom.ireland     = rlgdnie,
                    reldenom.israel      = rlgdnil,
                    reldenom.lithuania   = rlgdnlt,
                    reldenom.netherla    = rlgdnnl,
                    reldenom.norway      = rlgdnno,
                    reldenom.poland      = rlgdnapl,
                    reldenom.sweden      = rlgdnase,
                    reldenom.slovenia    = rlgdnsi,
                    frm.reldenom.any     = rlgblge,
                    frm.reldenom         = rlgdnme,
                    frm.reldenom.austria     = rlgdebat,
                    frm.reldenom.belgium     = rlgdebe,
                    frm.reldenom.switzerland = rlgdeach,
                    frm.reldenom.germany     = rlgdeade,
                    frm.reldenom.finland     = rlgdeafi,
                    frm.reldenom.uk          = rlgdegb,
                    frm.reldenom.hungary     = rlgdehu,
                    frm.reldenom.ireland     = rlgdeie,
                    frm.reldenom.israel      = rlgdeil,
                    frm.reldenom.lithuania   = rlgdelt,
                    frm.reldenom.netherla    = rlgdenl,
                    frm.reldenom.norway      = rlgdeno,
                    frm.reldenom.poland      = rlgdeapl,
                    frm.reldenom.sweden      = rlgdease,
                    frm.reldenom.slovenia    = rlgdesi,
                    religious     = rlgdgr,
                    relig.attend  = rlgatnd,
                    pray          = pray,
                    gender        = gndr,
                    age           = agea,
                    ybirth        = yrbrn,
                    eactive       = mnactic,
                    emplrel,
                    emplno,
                    isco08,
                    supervises    = jbspv,
                    nsupervised   = njbspv,
                    industry      = nacer2,
                    eactivep      = mnactp,
                    emplrelp      = emprelp,
                    isco08prtnr   = isco08p,
                    #emplnop,                 # Missing in data set - Yuck!
                    #supervisesp   = jbspvp,
                    #nsupervisedp  = njbspvp,
                    region,
                    ger.eastwest  = intewde,
                    w.design      = dweight,
                    w.poststrat   = pspwght,
                    year          = inwyys
                ))
Write(codebook(ESS.7),file="ESS-07-cdbk.txt")


ESS.8.sav <- spss.system.file("Data/ESS/ESS8e02_2.sav")
Write(description(ESS.8.sav),file="ESS-08-sav-desc.txt")
Write(codebook(ESS.8.sav),file="ESS-08-sav-cdbk.txt")

ESS.8 <- subset(ESS.8.sav,
                select=c(
                    essround,
                    idno,
                    cntry,
                    voted         = vote,
                    vote.austria  = prtvtbat,
                    vote.belgium  = prtvtcbe,
                    vote.czechia  = prtvtdcz,
                    vote.switzerland    = prtvtfch,
                    vote.germany  = prtvede2,
                    vote.estonia  = prtvtfee,
                    vote.spain    = prtvtdes,
                    vote.finland  = prtvtdfi,
                    vote.france   = prtvtcfr,
                    vote.uk       = prtvtbgb,
                    vote.hungary  = prtvtehu,
                    vote.ireland  = prtvtbie,
                    vote.israel   = prtvtcil,
                    vote.iceland  = prtvtbis,
                    vote.italy    = prtvtbit,
                    vote.lithuania1 = prtvblt1,
                    vote.lithuania2 = prtvblt2,
                    vote.lithuania3 = prtvblt3,
                    vote.netherla = prtvtfnl,
                    vote.norway   = prtvtbno,
                    vote.poland   = prtvtdpl,
                    vote.portugal = prtvtcpt,
                    vote.russia   = prtvtdru,
                    vote.sweden   = prtvtbse,
                    vote.slovenia = prtvtesi,
                    important_creative   = ipcrtiv,
                    important_rich       = imprich,
                    important_equality   = ipeqopt,
                    important_admired    = ipshabt,
                    important_safe       = impsafe,
                    important_trynew     = impdiff,
                    important_obedient   = ipfrule,
                    important_understand = ipudrst,
                    important_modest     = ipmodst,
                    important_goodtime   = ipgdtim,
                    important_freedom    = impfree,
                    important_helpothers = iphlppl,
                    important_success    = ipsuces,
                    important_stronggov  = ipstrgv,
                    important_exciting   = ipadvnt,
                    important_behavprop  = ipbhprp,
                    important_respect    = iprspot,
                    important_friends    = iplylfr,
                    important_environmt  = impenv,
                    important_tradition  = imptrad,
                    important_fun        = impfun,
                    reldenom.any  = rlgblg,
                    reldenom      = rlgdnm,   
                    reldenom.austria     = rlgdnbat,
                    reldenom.belgium     = rlgdnbe,
                    reldenom.switzerland = rlgdnach,
                    reldenom.germany     = rlgdnade,
                    reldenom.finland     = rlgdnafi,
                    reldenom.uk          = rlgdngb,
                    reldenom.hungary     = rlgdnhu,
                    reldenom.ireland     = rlgdnie,
                    reldenom.iceland     = rlgdnis,
                    reldenom.lithuania   = rlgdnlt,
                    reldenom.netherla    = rlgdnnl,
                    reldenom.norway      = rlgdnno,
                    reldenom.poland      = rlgdnapl,
                    reldenom.sweden      = rlgdnase,
                    frm.reldenom.any     = rlgblge,
                    frm.reldenom         = rlgdnme,
                    frm.reldenom.austria     = rlgdebat,
                    frm.reldenom.belgium     = rlgdebe,
                    frm.reldenom.switzerland = rlgdeach,
                    frm.reldenom.germany     = rlgdeade,
                    frm.reldenom.finland     = rlgdeafi,
                    frm.reldenom.uk          = rlgdegb,
                    frm.reldenom.hungary     = rlgdehu,
                    frm.reldenom.ireland     = rlgdeie,
                    frm.reldenom.iceland     = rlgdeis,
                    frm.reldenom.lithuania   = rlgdelt,
                    frm.reldenom.netherla    = rlgdenl,
                    frm.reldenom.norway      = rlgdeno,
                    frm.reldenom.poland      = rlgdeapl,
                    frm.reldenom.sweden      = rlgdease,
                    religious     = rlgdgr,
                    relig.attend  = rlgatnd,
                    pray          = pray,
                    gender        = gndr,
                    age           = agea,
                    ybirth        = yrbrn,
                    eactive       = mnactic,
                    emplrel,
                    emplno,
                    isco08,
                    supervises    = jbspv,
                    nsupervised   = njbspv,
                    industry      = nacer2,
                    eactivep      = mnactp,
                    emplrelp      = emprelp,
                    isco08prtnr   = isco08p,
                    #emplnop,                 # Missing in data set - Yuck!
                    #supervisesp   = jbspvp,
                    #nsupervisedp  = njbspvp,
                    region,
                    #regunit,
                    ger.eastwest  = intewde,
                    w.design      = dweight,
                    w.poststrat   = pspwght,
                    year          = inwyys
                ))
Write(codebook(ESS.8),file="ESS-08-cdbk.txt")


ESS.9.sav <- spss.system.file("Data/ESS/ESS9e03.sav")
Write(description(ESS.9.sav),file="ESS-09-sav-desc.txt")
Write(codebook(ESS.9.sav),file="ESS-09-sav-cdbk.txt")

ESS.9 <- subset(ESS.9.sav,
                select=c(
                    essround,
                    idno,
                    cntry,
                    voted         = vote,
                    vote.austria  = prtvtcat,
                    vote.belgium  = prtvtdbe,
                    vote.bulgaria = prtvtdbg,
                    vote.switzerland    = prtvtgch,
                    vote.cyprus   = prtvtbcy,
                    vote.czechia  = prtvtecz,
                    vote.germany  = prtvede2,
                    vote.denmark  = prtvtddk,
                    vote.estonia  = prtvtgee,
                    vote.spain    = prtvtees,
                    vote.finland  = prtvtdfi,
                    vote.france   = prtvtdfr,
                    vote.uk       = prtvtcgb,
                    vote.croatia  = prtvtahr,
                    vote.hungary  = prtvtfhu,
                    vote.ireland  = prtvtcie,
                    vote.iceland  = prtvtcis,
                    vote.italy    = prtvtcit,
                    vote.lithuania1 = prtvblt1,
                    vote.lithuania2 = prtvblt2,
                    vote.lithuania3 = prtvblt3,
                    vote.latvia   = prtvtalv,
                    vote.montenegro = prtvtme,
                    vote.netherla = prtvtgnl,
                    vote.norway   = prtvtbno,
                    vote.poland   = prtvtdpl,
                    vote.portugal = prtvtcpt,
                    vote.serbia   = prtvtrs,
                    vote.sweden   = prtvtcse,
                    vote.slovenia = prtvtfsi,
                    vote.slovakia = prtvtdsk,
                    important_creative   = ipcrtiv,
                    important_rich       = imprich,
                    important_equality   = ipeqopt,
                    important_admired    = ipshabt,
                    important_safe       = impsafe,
                    important_trynew     = impdiff,
                    important_obedient   = ipfrule,
                    important_understand = ipudrst,
                    important_modest     = ipmodst,
                    important_goodtime   = ipgdtim,
                    important_freedom    = impfree,
                    important_helpothers = iphlppl,
                    important_success    = ipsuces,
                    important_stronggov  = ipstrgv,
                    important_exciting   = ipadvnt,
                    important_behavprop  = ipbhprp,
                    important_respect    = iprspot,
                    important_friends    = iplylfr,
                    important_environmt  = impenv,
                    important_tradition  = imptrad,
                    important_fun        = impfun,
                    reldenom.any  = rlgblg,
                    reldenom      = rlgdnm,   
                    reldenom.austria     = rlgdnbat,
                    reldenom.belgium     = rlgdnbe,
                    reldenom.switzerland = rlgdnach,
                    reldenom.cyprus      = rlgdncy,
                    reldenom.germany     = rlgdnade,
                    reldenom.finland     = rlgdnafi,
                    reldenom.uk          = rlgdngb,
                    reldenom.hungary     = rlgdnhu,
                    reldenom.ireland     = rlgdnie,
                    reldenom.iceland     = rlgdnais,
                    reldenom.lithuania   = rlgdnlt,
                    reldenom.latvia      = rlgdnlv,
                    reldenom.montenegro  = rlgdme,
                    reldenom.netherla    = rlgdnnl,
                    reldenom.norway      = rlgdnno,
                    reldenom.poland      = rlgdnapl,
                    reldenom.serbia      = rlgdnrs,
                    reldenom.sweden      = rlgdnase,
                    reldenom.slovakia    = rlgdnask,
                    frm.reldenom.any     = rlgblge,
                    frm.reldenom         = rlgdnme,
                    frm.reldenom.austria     = rlgdebat,
                    frm.reldenom.belgium     = rlgdebe,
                    frm.reldenom.switzerland = rlgdeach,
                    frm.reldenom.cyprus      = rlgdecy,
                    frm.reldenom.germany     = rlgdeade,
                    frm.reldenom.finland     = rlgdeafi,
                    frm.reldenom.uk          = rlgdegb,
                    frm.reldenom.hungary     = rlgdehu,
                    frm.reldenom.ireland     = rlgdeie,
                    frm.reldenom.iceland     = rlgdeais,
                    frm.reldenom.lithuania   = rlgdelt,
                    frm.reldenom.latvia      = rlgdelv,
                    frm.reldenom.montenegro  = rlgdeme,
                    frm.reldenom.netherla    = rlgdenl,
                    frm.reldenom.norway      = rlgdeno,
                    frm.reldenom.poland      = rlgdeapl,
                    frm.reldenom.serbia      = rlgders,
                    frm.reldenom.sweden      = rlgdease,
                    frm.reldenom.slovakia    = rlgdeask,
                    religious     = rlgdgr,
                    relig.attend  = rlgatnd,
                    pray          = pray,
                    gender        = gndr,
                    age           = agea,
                    ybirth        = yrbrn,
                    eactive       = mnactic,
                    emplrel,
                    emplno,
                    isco08,
                    supervises    = jbspv,
                    nsupervised   = njbspv,
                    industry      = nacer2,
                    eactivep      = mnactp,
                    emplrelp      = emprelp,
                    isco08prtnr   = isco08p,
                    #emplnop,                 # Missing in data set - Yuck!
                    #supervisesp   = jbspvp,
                    #nsupervisedp  = njbspvp,
                    region,
                    regunit,
                    # ger.eastwest  = intewde,
                    w.design      = dweight,
                    w.poststrat   = pspwght,
                    year          = inwyys
                ))
Write(codebook(ESS.9),file="ESS-09-cdbk.txt")


ESS.10.sav <- spss.system.file("Data/ESS/ESS10.sav")
Write(description(ESS.10.sav),file="ESS-10-sav-desc.txt")
Write(codebook(ESS.10.sav),file="ESS-10-sav-cdbk.txt")

ESS.10 <- subset(ESS.10.sav,
                select=c(
                    essround,
                    idno,
                    cntry,
                    voted         = vote,
                    vote.belgium = prtvtebe,
                    vote.bulgaria = prtvtebg,
                    vote.switzerland = prtvthch,
                    vote.croatia = prtvtbhr,
                    vote.czechia = prtvtecz,
                    vote.estonia = prtvthee,
                    vote.finland = prtvtefi,
                    vote.france = prtvtefr,
                    vote.greece = prtvtdgr,
                    vote.hungary = prtvtghu,
                    vote.iceland = prtvtdis,
                    vote.ireland = prtvtdie,
                    vote.italy = prtvtdit,
                    vote.lithuania1 = prtvclt1,
                    vote.lithuania2 = prtvclt2,
                    vote.lithuania3 = prtvclt3,
                    vote.montenegro = prtvtame,
                    vote.netherla = prtvthnl,
                    vote.macedonia = prtvtmk,
                    vote.norway = prtvtbno,
                    vote.portugal = prtvtdpt,
                    vote.slovenia = prtvtfsi,
                    vote.slovakia = prtvtesk,
                    vote.uk = prtvtdgb,
                    important_creative   = ipcrtiv,
                    important_rich       = imprich,
                    important_equality   = ipeqopt,
                    important_admired    = ipshabt,
                    important_safe       = impsafe,
                    important_trynew     = impdiff,
                    important_obedient   = ipfrule,
                    important_understand = ipudrst,
                    important_modest     = ipmodst,
                    important_goodtime   = ipgdtim,
                    important_freedom    = impfree,
                    important_helpothers = iphlppl,
                    important_success    = ipsuces,
                    important_stronggov  = ipstrgv,
                    important_exciting   = ipadvnt,
                    important_behavprop  = ipbhprp,
                    important_respect    = iprspot,
                    important_friends    = iplylfr,
                    important_environmt  = impenv,
                    important_tradition  = imptrad,
                    important_fun        = impfun,
                    reldenom.any         = rlgblg,
                    reldenom             = rlgdnm,   
                    reldenom.switzerland = rlgdnach,
                    reldenom.finland     = rlgdnafi,
                    reldenom.greece      = rlgdnagr,
                    reldenom.hungary     = rlgdnhu, 
                    reldenom.iceland     = rlgdnais,
                    reldenom.ireland     = rlgdnie, 
                    reldenom.lithuania   = rlgdnlt, 
                    reldenom.montenegro  = rlgdme, 
                    reldenom.netherla    = rlgdnanl,
                    reldenom.macedonia   = rlgdnmk, 
                    reldenom.norway      = rlgdnno, 
                    reldenom.slovakia    = rlgdnbsk,
                    reldenom.uk          = rlgdngb, 
                    frm.reldenom.any         = rlgblge,
                    frm.reldenom             = rlgdnme,
                    frm.reldenom.switzerland = rlgdeach, 
                    frm.reldenom.finland     = rlgdeafi, 
                    frm.reldenom.greece      = rlgdeagr, 
                    frm.reldenom.hungary     = rlgdehu,  
                    frm.reldenom.iceland     = rlgdeais, 
                    frm.reldenom.ireland     = rlgdeie,  
                    frm.reldenom.lithuania   = rlgdelt,  
                    frm.reldenom.montenegro  = rlgdeme,  
                    frm.reldenom.netherla    = rlgdeanl, 
                    frm.reldenom.macedonia   = rlgdemk,  
                    frm.reldenom.norway      = rlgdeno,  
                    frm.reldenom.slovakia    = rlgdebsk, 
                    frm.reldenom.uk          = rlgdegb,  
                    religious     = rlgdgr,
                    relig.attend  = rlgatnd,
                    pray          = pray,
                    gender        = gndr,
                    age           = agea,
                    ybirth        = yrbrn,
                    eactive       = mnactic,
                    emplrel,
                    emplno,
                    isco08,
                    supervises    = jbspv,
                    nsupervised   = njbspv,
                    industry      = nacer2,
                    eactivep      = mnactp,
                    emplrelp      = emprelp,
                    isco08prtnr   = isco08p,
                    #emplnop,                 # Missing in data set - Yuck!
                    #supervisesp   = jbspvp,
                    #nsupervisedp  = njbspvp,
                    region,
                    regunit,
                    # ger.eastwest  = intewde,
                    w.design      = dweight,
                    w.poststrat   = pspwght,
                    interview_start = inwds
                ))
Write(codebook(ESS.10),file="ESS-10-cdbk.txt")



library(magrittr)

ESS.1 %<>% within({
    essround <- 1
    # Berlin is East Germany
    ger.eastwest[regionde==11] <- 1
})

ESS.2 %<>% within({
    essround <- 2
    # Berlin is East Germany
    ger.eastwest[regionde==11] <- 1
})

ESS.3 %<>% within({
    essround <- 3
    # Berlin is East Germany
    ger.eastwest[regionde==11] <- 1
})

ESS.4 %<>% within({
    essround <- 4
    # Berlin is East Germany
    ger.eastwest[regionde==11] <- 1
})

ESS.5 %<>% within({
    essround <- 5
    # Berlin is East Germany
    ger.eastwest[region=="DE3"] <- 1
})

ESS.6 %<>% within({
    essround <- 6
    # Berlin is East Germany
    ger.eastwest[region=="DE3"] <- 1
})

ESS.7 %<>% within({
    essround <- 7
    # Berlin is East Germany
    ger.eastwest[region=="DE3"] <- 1
})

ESS.8 %<>% within({
    essround <- 8
    # Berlin is East Germany
    ger.eastwest[region=="DE3"] <- 1
})

ESS.9 %<>% within({
    essround <- 9
    # There is no East-Germany/ West-Germany variable
    ger.eastwest <- recode(region,
                       East = 1 <- c("DE3","DE4","DE8","DED","DEE","DEG"),
                       West = 2 <- c("DE1","DE2","DE5","DE6","DE7","DE9","DEA","DEB","DEC","DEF")
                       )
    ger.eastwest <- as.numeric(ger.eastwest)
})

get_year <- function(x){
    as.integer(strftime(as.POSIXct(x),"%Y"))
}

ESS.10 %<>% within({
    essround <- 10
    year <- get_year(interview_start)
    rm(interview_start)
    # There is no East-Germany/ West-Germany variable
    # ger.eastwest <- recode(region,
    #                    East = 1 <- c("DE3","DE4","DE8","DED","DEE","DEG"),
    #                    West = 2 <- c("DE1","DE2","DE5","DE6","DE7","DE9","DEA","DEB","DEC","DEF")
    #                    )
    # ger.eastwest <- as.numeric(ger.eastwest)
})


save(
    ESS.1,
    ESS.2,
    ESS.3,
    ESS.4,
    ESS.5,
    ESS.6,
    ESS.7,
    ESS.8,
    ESS.9,
    ESS.10,
    file="ESS-cumul-1-10.RData"
)

